function RGBdata = hsl2rgb(HSLdata)

    MatSize = size(HSLdata);
    RGBdata = zeros(MatSize);
    
    hMat = HSLdata(:,:,1);
	sMat = HSLdata(:,:,2);
	lMat = HSLdata(:,:,3);

    for i = 1:MatSize(1)
        for j = 1:MatSize(2)

            h = hMat(i,j);
            s = sMat(i,j);
            l = lMat(i,j);
    
            if(s == 0)
                r = l;
                g = l;
                b = l;
            else
                temp2 = l - abs(l - .5) * s + .5 * s;
                temp1 = 2 * l - temp2;
                
                Hue = h/360.0;
                
                tempr = Hue + 1/3;
                if(tempr > 1)
                    tempr = tempr - 1;
                end
                tempg = Hue;
                tempb = Hue - 1/3;
                if(tempb < 0)
                    tempb = tempb + 1;
                end
                
                % Red
                if(tempr < 1.0 / 6.0) 
                    r = temp1 + (temp2 - temp1) * 6.0 * tempr;
                elseif(tempr < 0.5) 
                    r = temp2;
                elseif(tempr < 2.0 / 3.0) 
                    r = temp1 + (temp2 - temp1) * ((2.0 / 3.0) - tempr) * 6.0;
                else
                    r = temp1;
                end
                
                % Green
                if(tempg < 1.0 / 6.0) 
                    g = temp1 + (temp2 - temp1) * 6.0 * tempg;
                elseif(tempg < 0.5) 
                    g = temp2;
                elseif(tempg < 2.0 / 3.0) 
                    g = temp1 + (temp2 - temp1) * ((2.0 / 3.0) - tempg) * 6.0;
                else
                    g = temp1;
                end

                % Blue
                if(tempb < 1.0 / 6.0) 
                    b = temp1 + (temp2 - temp1) * 6.0 * tempb;
                elseif(tempb < 0.5) 
                    b = temp2;
                elseif(tempb < 2.0 / 3.0) 
                    b = temp1 + (temp2 - temp1) * ((2.0 / 3.0) - tempb) * 6.0;
                else
                    b = temp1;
                end
                    
            end
            
            RGBdata(i,j,1) = round(r * 255.0);
            RGBdata(i,j,2) = round(g * 255.0);
            RGBdata(i,j,3) = round(b * 255.0);
        end
    end
    

end
